org 100h   ; assume ax=bx=0 si=0x100 di=sp=-2

  mov al,0x13
  int 0x10     ; set 320x200 mode

  mov dx,0x3c8 ; palette: 8 color gradients
  mov cx,0x300
P mov al,0x3e  ; ah=0
  add bx,ax
  ror al,cl
  mul bh
  shr ax,9
  out dx,al
  mov dl,0xc9
  loop P       ; bx=0x4500

;; Palette test
;  push 0xa000
;  pop es
;  xor di,di
;  xor ax,ax
;Y stosb
;  inc al
;  jnz Y
;  add di,64
;  jns Y
;
;  xor ax,ax
;  int 0x16
;  ret

  mov bh,0x40
  mov gs,bx    ; bx=gs=0x4000: table segment, sin->cos phase

  push 0xa000 - 160/16 ; sp=-4

;Sine table: 16384 float32 entries (-1..1)
  fninit       ; [di]=0
S mov bp,[di]
  fild word[di]                           ;| t
  fidiv word[si-0x100+c65536div2pi]  ;| T=t/65536*2pi
  fsin                                    ;| sinT
  fstp dword[gs:bp+si]
  sub [di],sp  ; +4
  jnz S        ; bp=-4

  pop es       ; es=0x9ff6: centered screen segment

M:

;For each pixel: find dX,dY,dZ and initialize X,Y,Z
X mov ax,0xcccd
  mul di
  mov cl,0x7c  ; cl:dh=dZ=0x7c??
  add dh,0x9f  ; dh:dl=dY
  xchg ax,bx   ; dl:bh=dX
  pusha        ; -10 -9 -8 -7 -6 -5 -4 -3
               ;  bl bh dl dh cl ch al ah
               ;     ( dX )      0  0  0x40
               ;        ( dY )
               ;           ( dZ )

               ; si=Z=time
  cwd          ; dx=Y=0
               ; ax=X=0x4000
  mov bx,ax    ; bx=0x4000

Z:

;Compute the signed distance to the gyroid
  fldl2e       ;| d=1.442695
;  fld dword[cOffset]
G fld dword[gs:si+bx]
  xchg ax,dx   ;| cosZ d | cosY d | cosX d
  xchg ax,si   ; ax=X dx=Y si=Z -> ax=Z dx=X si=Y
  fmul dword[gs:si]
  fchs
  faddp        ;| d+=cosZ*sinY | d+=cosY*sinX | d+=cosX*sinZ
  inc bp
  jpo G        ; bp=-1 ;| d = cosZ*sinY + cosY*sinX + cosX*sinZ + 1.442695

;Advance ray by the distance
A fild word[bp-6]; bp = -1 | -2 | -3
  fmul st1     ;| dZ*d | dY*d | dX*d
  fmul dword[cDistFactor]
  fistp word[bx]
  xchg ax,dx
  xchg ax,si   ; ax=X dx=Y si=Z -> ax=Z dx=X si=Y
  add ax,[bx]   ; Z+=dZ*d | Y+=dY*d | X+=dX*d
  and al,0xfc  ; align to a multiple of 4 (for sine table)
  dec bp
  jpo A        ; bp=-4

;Are we close enough?
  fstp dword[bx]; store d as float32
  cmp byte[bx+3],0x3d ; cmp bits(d),0x3d000000
  jl E         ; hit if d<0.03125
  dec cx
  loop Z       ; max 128 iterations

;Draw pixel
E:xchg ax,cx
;  adc al,al
  shl al,1     ; lsb = color bit = sign
  or al,7
  stosb
  popa
  xchg ax,bx

;Next pixel
D:inc di
  jnz X

;Next frame

  add si,4*512 ; time++
  in al,0x60   ; esc check
  dec al
  jnz M
  ret

c65536div2pi: dw 10430 ; 65536/2pi
cDistFactor: dd 0.175 ; (0.75 (Lipchitz constant) / 44700 (avg dir length)) * 65536/2pi
;cOffset: dd 1.442695
